/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.attn.np;

import com.ibm.hwmca.fw.attn.AttentionID;
import com.ibm.hwmca.fw.attn.np.AttentionCoreInfo;
import com.ibm.hwmca.fw.attn.np.AttentionRequest;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ActionDescriptor;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class HwMessagesBean
extends PanelBean {
    private static final String TRACE_MASKT = "XEMP001T";
    private static final String TRACE_MASKF = "XEMP001F";
    private static final String TRACE_MASKD = "XEMP001D";
    private static long unique = 0L;
    private int[] m_iMsgTableSelection;
    private ActionDescriptor[] m_adContextMenu;
    private ColumnDescriptor[] m_cdMsgTableStructure;
    private ItemDescriptor[] m_idMsgTable;
    private ObjectId moID;
    private List tableData = new ArrayList();
    private Lock tableLock = new Lock();

    public HwMessagesBean(ObjectId moID) {
        Trace.trace(TRACE_MASKT, ">> HwMessagesBean() : ID=" + moID);
        if (moID == null) {
            throw new IllegalArgumentException("Illegal null value");
        }
        this.moID = moID;
        Trace.trace(TRACE_MASKT, "<< HwMessagesBean()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshTableData(List infos) {
        Trace.trace(TRACE_MASKT, ">> refreshTableData() : BEAN = " + this.getBeanName() + " : COUNT = " + infos.size());
        if (infos == null) throw new IllegalArgumentException("Illegal null value");
        boolean valid = true;
        Iterator i = infos.iterator();
        while (i.hasNext() && valid) {
            valid = i.next() instanceof AttentionCoreInfo;
        }
        if (!valid) throw new IllegalStateException("Illegal value encountered");
        Lock lock = this.tableLock;
        synchronized (lock) {
            this.tableData = infos;
            Collections.sort(this.tableData, new SortByDescendingDate());
        }
        if (this.userTaskManager != null) {
            Trace.trace(TRACE_MASKF, "-----> Clearing row selection...");
            this.setMsgTableSelection(new int[0]);
            this.userTaskManager.refreshElement(this.getMountPrefix() + "MsgTable");
        }
        Trace.trace(TRACE_MASKT, "<< refreshTableData()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, ">> prepare() : BEAN = " + this.getBeanName());
        String prefix = this.getMountPrefix();
        this.userTaskManager.setEnabled(prefix + "DetailsButton", true);
        this.userTaskManager.setEnabled(prefix + "DeleteButton", true);
        this.userTaskManager.setEnabled(prefix + "SelectButton", true);
        this.userTaskManager.setEnabled(prefix + "DeselallButton", true);
        Trace.trace(TRACE_MASKT, "<< prepare()");
    }

    public void update(Object object) {
        Trace.trace(TRACE_MASKT, ">> update() : BEAN = " + this.getBeanName());
        if (object != null && object instanceof List) {
            this.refreshTableData((List)object);
        }
        Trace.trace(TRACE_MASKT, "<< update()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, ">> panelAction() : \n   Bean Name     : " + this.getBeanName() + "\n   CurrentElement: " + event.getCurrentElement() + "\n   ElementName   : " + event.getElementName() + "\n   ActionCommand : " + event.getActionCommand());
        String elementName = event.getElementName();
        int[] selected = this.getMsgTableSelection();
        if (elementName.endsWith("DetailsButton") || elementName.endsWith("DetailsChoice")) {
            if (selected.length > 0) {
                AttentionID[] data = new AttentionID[selected.length];
                int i = 0;
                while (i < selected.length) {
                    data[i] = ((AttentionCoreInfo)this.tableData.get(selected[i])).getAttentionID();
                    ++i;
                }
                AttentionRequest request = new AttentionRequest("CLIENT", "DETAILS", this.moID, data);
                this.postTaskletRequest(request);
            }
        } else if (elementName.endsWith("DeleteButton")) {
            if (selected.length > 0) {
                AttentionID[] data = new AttentionID[selected.length];
                int i = 0;
                while (i < selected.length) {
                    data[i] = ((AttentionCoreInfo)this.tableData.get(selected[i])).getAttentionID();
                    ++i;
                }
                AttentionRequest request = new AttentionRequest("CLIENT", "DELETE", this.moID, data);
                this.postTaskletRequest(request);
            }
        } else if (elementName.endsWith("SelectButton")) {
            selected = new int[this.tableData.size()];
            int i = 0;
            while (i < selected.length) {
                selected[i] = i;
                ++i;
            }
            Trace.trace(TRACE_MASKF, "-----> Selecting all rows...");
            this.setMsgTableSelection(selected);
            this.userTaskManager.refreshElement(this.getMountPrefix() + "MsgTable");
        } else if (elementName.endsWith("DeselallButton")) {
            Trace.trace(TRACE_MASKF, "-----> Clearing row selections...");
            this.setMsgTableSelection(new int[0]);
            this.userTaskManager.refreshElement(this.getMountPrefix() + "MsgTable");
        } else if (elementName.endsWith("CancelButton")) {
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<< panelAction()");
    }

    private void setButtonStates() {
        if (this.userTaskManager != null) {
            String prefix = this.getMountPrefix();
            int[] selected = this.getMsgTableSelection();
            if (selected.length == 0) {
                this.userTaskManager.setEnabled(prefix + "DeleteButton", false);
                this.userTaskManager.setEnabled(prefix + "DetailsButton", false);
                this.userTaskManager.setEnabled(prefix + "DeselallButton", false);
            } else {
                this.userTaskManager.setEnabled(prefix + "DeleteButton", true);
                this.userTaskManager.setEnabled(prefix + "DetailsButton", true);
                this.userTaskManager.setEnabled(prefix + "DeselallButton", true);
            }
            if (this.tableData.size() > 0 && selected.length < this.tableData.size()) {
                this.userTaskManager.setEnabled(prefix + "SelectButton", true);
            } else {
                this.userTaskManager.setEnabled(prefix + "SelectButton", false);
            }
        } else {
            Trace.trace(TRACE_MASKF, "   UserTaskManager not available yet...");
        }
    }

    public int getMsgTableRowCount() {
        Trace.trace(TRACE_MASKT, "<> getMsgTableRowCount() : " + this.tableData.size());
        return this.tableData.size();
    }

    public ItemDescriptor[] getMsgTableRowAt(int index) {
        Trace.trace(TRACE_MASKT, ">> getMsgTableRowAt() : " + index);
        AttentionCoreInfo info = (AttentionCoreInfo)this.tableData.get(index);
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss z");
        timeFormat.setTimeZone(info.getTimeZone());
        String name = "_ROW" + index;
        this.m_idMsgTable = new ItemDescriptor[3];
        this.m_idMsgTable[0] = new ItemDescriptor("Date" + name, dateFormat.format(info.getCreationDate()));
        this.m_idMsgTable[1] = new ItemDescriptor("Time" + name, timeFormat.format(info.getCreationDate()));
        this.m_idMsgTable[2] = new ItemDescriptor("Text" + name, info.getDescription().toString());
        Trace.trace(TRACE_MASKT, "<< getMsgTableRowAt()");
        return this.m_idMsgTable;
    }

    public void setMsgTableRowAt(int index, ItemDescriptor[] items) {
        Trace.trace(TRACE_MASKT, ">> setMsgTableRowAt() : " + index + " : " + items);
        this.m_idMsgTable = items;
        Trace.trace(TRACE_MASKT, "<< setMsgTableRowAt()");
    }

    public void setMsgTableSelection(int[] selected) {
        Trace.trace(TRACE_MASKT, "<> setMsgTableSelection() : " + selected.length);
        this.m_iMsgTableSelection = selected;
    }

    public int[] getMsgTableSelection() {
        Trace.trace(TRACE_MASKT, "<> getMsgTableSelection() : " + this.m_iMsgTableSelection.length);
        return this.m_iMsgTableSelection;
    }

    public void load() {
        this.m_adContextMenu = new ActionDescriptor[0];
        this.m_idMsgTable = new ItemDescriptor[0];
        this.m_iMsgTableSelection = new int[0];
        this.m_cdMsgTableStructure = new ColumnDescriptor[3];
        this.m_cdMsgTableStructure[0] = new ColumnDescriptor("DateCol001", "Date", false);
        this.m_cdMsgTableStructure[1] = new ColumnDescriptor("TimeCol001", "Time", false);
        this.m_cdMsgTableStructure[2] = new ColumnDescriptor("TextCol001", "Description", false);
    }

    public ColumnDescriptor[] getMsgTableRowStructure() {
        return this.m_cdMsgTableStructure;
    }

    public int getMsgTableRowStatus() {
        return 3;
    }

    public ActionDescriptor[] getContextMenuList() {
        return null;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    private static class Lock
    implements Serializable {
    }

    private static class SortByDescendingDate
    implements Comparator {
        private SortByDescendingDate() {
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            if (!(o1 instanceof AttentionCoreInfo) || !(o2 instanceof AttentionCoreInfo)) {
                throw new ClassCastException("Incompatible classes");
            }
            result = ((AttentionCoreInfo)o1).getCreationDate().compareTo(((AttentionCoreInfo)o2).getCreationDate());
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof SortByDescendingDate;
        }
    }
}

